/**
 * MMP 1
 * MultiMediaTechnology - FH Salzburg
 * Author: Felix Beer
 *
 * This shader was partly generated by ChatGPT but had to be modified to work properly
 */

uniform sampler2D texture;
uniform float time;
uniform float magnitude;

void main()
{
    // Get the current texture coordinate
    vec2 texCoord = gl_TexCoord[0].xy;

    // Calculate the offset based on time and magnitude
    float offsetX = sin(time * 25.0) * magnitude;
    float offsetY = cos(time * 15.0) * magnitude;

    // Apply the offset to the texture coordinate
    texCoord.x += offsetX;
    texCoord.y += offsetY;

    // Sample the texture at the modified texture coordinate
    vec4 color = texture2D(texture, texCoord);

    // Output the resulting color
    gl_FragColor = color;
}